from urllib.parse import quote, quote_plus
import requests
import xbmcaddon
from .utils import log, dump
from resolveurl.plugins.realdebrid import RealDebridResolver

USER_AGENT = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:132.0) Gecko/20100101 Firefox/132.0'
HEADERS = {"User-Agent": USER_AGENT}
ADDON = xbmcaddon.Addon()


class Cache:
    
    def movie_url(self, debrid: str, imdb_id: str) -> str:
        return f'https://torrentio.strem.fun/{debrid}=xxxxxxxxxxxxxxxxxxxxxxxxxxxx/stream/movie/{imdb_id}.json'

    def episode_url(self, debrid: str, imdb_id: str, season_number: int, episode_number: int) -> str:
         return f'https://torrentio.strem.fun/{debrid}=xxxxxxxxxxxxxxxxxxxxxxxxxxxx/stream/movie/{imdb_id}%3A{season_number}%3A{episode_number}.json'
         
    def _check_cache(self, debrid: str, hashes, imdb_id, season_number=None, episode_number=None):
        cached_hashes = []
        url = self.episode_url(debrid, imdb_id, season_number, episode_number) if episode_number else self.movie_url(debrid, imdb_id)
        try:
            response = requests.get(url, headers=HEADERS, timeout=10).json()
            streams = response.get('streams', [])
            cached = '' if debrid == 'realdebrid' else dump(response)
            if debrid == 'realdebrid':
                for stream in streams:
                    if '[RD+]' in stream.get('name'):
                        cached += stream['url']
            
            for _hash in hashes:
                #if _hash in response.lower() and _hash not in cached_hashes:
                if _hash in cached.lower() and _hash not in cached_hashes:
                    cached_hashes.append(_hash)
        except:
            pass
        return cached_hashes


class RD(Cache):
    def __init__(self):
        self.base_url = 'https://api.real-debrid.com/rest/1.0/'
        self.user_agent = f'ResolveURL for Kodi/{xbmcaddon.Addon("script.module.resolveurl").getAddonInfo("version")}'
    
    @property
    def enabled(self):
        return xbmcaddon.Addon('script.module.resolveurl').getSettingBool('RealDebridResolver_enabled') is True and xbmcaddon.Addon('script.module.resolveurl').getSetting('RealDebridResolver_token') != ''
    
    def check_cache(self, hashes, imdb_id, season_number=None, episode_number=None):
        if self.enabled is True:
            return self._check_cache('realdebrid', hashes, imdb_id, season_number, episode_number)
        return []

    def get(self, url, retry=False):
        resolve_url = xbmcaddon.Addon('script.module.resolveurl')
        token = resolve_url.getSetting('RealDebridResolver_token')
        headers = {'User-Agent': self.user_agent, 'Authorization': f'Bearer {token}'}
        _url = f'{self.base_url}{url}'
        params = {
            'auth_token': token
        }
        response = requests.get(_url, params=params, headers=headers, timeout=20)
        if retry is False and response.status_code == 401:
            if xbmcaddon.Addon('script.module.resolveurl').getSetting('RealDebridResolver_refresh'):
                RealDebridResolver().refresh_token()
                return self.get(url, retry=True)
        return response.json()


class AD(Cache):
    def __init__(self):
        self.base_url = 'https://api.alldebrid.com/v4/'
        self.user_agent = f"{ADDON.getAddonInfo('name')} for Kodi"
    
    @property
    def enabled(self):
        return xbmcaddon.Addon('script.module.resolveurl').getSettingBool('AllDebridResolver_enabled') is True and xbmcaddon.Addon('script.module.resolveurl').getSetting('AllDebridResolver_token') != ''
     
    def check_cache(self, hashes, imdb_id, season_number=None, episode_number=None):
        if self.enabled is True:
            return self._check_cache('alldebrid', hashes, imdb_id, season_number, episode_number)
        return []
    
    def get(self, url: str, hashes: list):
        url = f'{self.base_url}{url}'
        params = {
            'apikey': xbmcaddon.Addon('script.module.resolveurl').getSetting('AllDebridResolver_token'),
            'agent': quote(self.user_agent)
        }
        data = {
            'magnets[]': hashes
        }
        return requests.post(url, params=params, data=data, timeout=20).json()
    
    def resolve(self, url):
        link = f"{self.base_url}link/unlock?agent={quote_plus(self.user_agent)}&apikey={xbmcaddon.Addon('script.module.resolveurl').getSetting('AllDebridResolver_token')}&link={quote_plus(url)}"
        
        response = requests.get(link, headers={'User-Agent': self.user_agent}, timeout=10).json()
        if response.get('status') == "success":
            return response.get('data').get('link', '')
        return ''
        

class PM():
    def __init__(self):
        self.base_url = 'https://www.premiumize.me/api/'
        self.token = xbmcaddon.Addon('script.module.resolveurl').getSetting('PremiumizeMeResolver_token')
    
    @property
    def enabled(self):
        return xbmcaddon.Addon('script.module.resolveurl').getSettingBool('PremiumizeMeResolver_enabled') is True and xbmcaddon.Addon('script.module.resolveurl').getSetting('PremiumizeMeResolver_token') != ''
    
    def get(self, url, data=None):
        auth = f'Bearer {self.token}'
        headers = {'Authorization': auth}
        return requests.post(url, data=data, headers=headers, timeout=10).json()
    
    def check_cache(self, hashes):
        cached_hashes = []
        if self.enabled is False:
            return cached_hashes
        url = f'{self.base_url}cache/check'
        data = {'items[]': hashes}
        response = self.get(url, data)
        checked = []
        if response.get('status') == 'success':
            checked = response.get('response', [])
        if checked:
            for _hash in range(len(hashes)):
                if checked[_hash] is True:
                    cached_hashes.append(hashes[_hash])
        return cached_hashes