import os
import json
import xbmc
import xbmcaddon
import xbmcvfs
from .monitor import PlaybackMonitor


ADDON = xbmcaddon.Addon()
ADDON_ID = ADDON.getAddonInfo('id')
ADDON_PATH = xbmcvfs.translatePath(ADDON.getAddonInfo('path'))
XML_FOLDER = os.path.join(ADDON_PATH, 'xml')
RECENTS_FILE = os.path.join(XML_FOLDER, 'recents.json')


def create_recents():
    if not xbmcvfs.exists(RECENTS_FILE):
        item = {
            'type': 'item',
            'title': '[B][COLOR gold]- - -Recently Played- - -[/COLOR][/B]'
        }
        with open(RECENTS_FILE, 'w', encoding='utf-8') as f:
            f.write(json.dumps({'items': [item]}))

def update_recents(item, resume_time=0, total_time=0):
    create_recents()
    title = item.get('title')
    item['recent'] = True
    with open(RECENTS_FILE, 'r', encoding='utf-8', errors='ignore') as f:
        items = json.loads(f.read())['items']
        
    for _item in items:
        if '-Recently Played-' in _item.get('title'):
            items.remove(_item)
            break
    
    for _item in items:
        if 'Clear All Recently Played Items' in _item.get('title'):
            items.remove(_item)
            break
            
    for _item in items:
        if title == _item.get('title'):
            items.remove(_item)
            break
            
    if resume_time > 0:
        item['resume_time'] = resume_time
    if total_time > 0:
        item['total_time'] = total_time
        
    items.reverse()
    items.append(item)
    items.reverse()
    
    new_items = [
        {
            'type': 'item',
            'title': '[B][COLOR gold]- - -Recently Played- - -[/COLOR][/B]'
        },
        {
            'type': 'item',
            'title': '[B][COLOR red]Clear All Recently Played Items[/COLOR][/B]',
            'link': 'remove_recents'
        }
    ]
    new_items.extend(items)
    
    with open(RECENTS_FILE, 'w', encoding='utf-8') as f:
        f.write(json.dumps({'items': new_items}, indent=2))

def remove_recently_played():
    items = [
        {
            'type': 'item',
            'title': '[B][COLOR gold]- - -Recently Played- - -[/COLOR][/B]'
        }
    ]
    
    with open(RECENTS_FILE, 'w', encoding='utf-8') as f:
        f.write(json.dumps({'items': items}, indent=2))
    xbmc.executebuiltin("Container.Refresh")
    
    
def monitor_playback(item):
    player = xbmc.Player()
    monitor = PlaybackMonitor()
    resume_time = 0
    total_time = 0
    while not monitor.abortRequested() and monitor.stopped is False:
        if player.isPlayingVideo():
            try:
                resume_time = player.getTime()
                total_time = player.getTotalTime()
            except RuntimeError as e:
                xbmc.log(f'RuntimeError: {e}', xbmc.LOGINFO)
        monitor.waitForAbort(1)
    
    update_recents(item, resume_time, total_time)