import json
import time
import xbmc
from ..util.common import ownAddon
from ..DI import DI
from ..plugin import Plugin


class cached_list(Plugin):
    name = "Cached List"
    priority = 1000
    
    def get_list(self, url):
        if ownAddon.getSettingBool("use_cache") is False:
            return
        cache_timer =  float(ownAddon.getSetting("time_cache") or 0)
        cached = DI.db.get(url)
        if not cached:
            return
        response, created = cached
        
        try:
            if (created + json.loads(response).get("cache_time", cache_timer)*60) < time.time():
                return
        except json.decoder.JSONDecodeError as e:
            xbmc.log(f'Json Error: {e}', xbmc.LOGINFO)
            if (created + cache_timer*60) < time.time():
                return
        return response
    
    def routes(self, plugin):
        @plugin.route("/clear_cache")
        def clear_cache():
            DI.db.clear_cache()
            xbmc.executebuiltin("Container.Refresh")
