import xbmcgui
from ..plugin import Plugin
from ..util.common import default_icon, default_fanart, set_info
from ..modules.utils import log

class DefaultGetMeta(Plugin):
    name = "default get meta"
    description = "Process Item Metadata"
    priority = 0

    def get_metadata(self, item):
        content = item.get("content", "video")
        title = item.get("title", "")
        thumbnail = item.get("thumbnail", default_icon)
        fanart = item.get("fanart", default_fanart)
        summary = item.get("summary", title)
        resume_time = item.get('resume_time')
        total_time = item.get('total_time')
        infolabels = item.get("infolabels") or {
            "mediatype": content,
            "title": title,
            "plot": summary,
            "plotoutline": summary
        }
        cast = item.get('cast', [])
        liz = xbmcgui.ListItem(title, offscreen=True)
        liz.setArt({"thumb": thumbnail, "icon": thumbnail, "poster": thumbnail, "fanart": fanart})
        set_info(liz, infolabels, cast)
        
        menu = []
        if "contextmenu" in item:
            contextmenu = item.get("contextmenu")
            for c in contextmenu:
                action = c.get("action")
                menu.append((c.get("label"), action))
            liz.addContextMenuItems(menu)
        if resume_time:
            liz.setProperty("ResumeTime", str(resume_time))
        if total_time:
            liz.setProperty("TotalTime", str(total_time))
        if item.get('is_playable') is True:
            liz.setProperty('IsPlayable', 'true')
        item['list_item'] = liz
        return item
        