import sys
import json
import xbmcgui
import xbmcplugin
from ..util.common import default_icon, set_info
from ..modules.recently_played import monitor_playback
from ..modules.dialogs import select_dialog
from ..plugin import Plugin
import resolveurl


class default_play_video(Plugin):
    name = "default video playback"
    priority = 0
    
    def play_video(self, video):
        item = json.loads(video)
        link = item.get("link", "")
        if link in ("", "http://ignorame"):
            return
        if str(link).startswith('vi'):
            link = f'plugin://plugin.video.imdb.trailers/?action=play&videoid={link}'
        title = item["title"]
        thumbnail = item.get("thumbnail", default_icon)
        from ..modules.tmdb_api import get_clearlogo
        clearlogo = get_clearlogo(imdb_id=item.get('imdb'))
        summary = item.get("summary", title)
        liz = xbmcgui.ListItem(title)
        set_info(liz, {"title": title, "plot": summary})
        liz.setArt({"thumb": thumbnail, "icon": thumbnail, "poster": thumbnail, 'clearlogo': clearlogo})
        
        if item.get('pack') is not None:
            hmf = resolveurl.HostedMediaFile(link, return_all=True)
            if hmf:
                allfiles = hmf.resolve()
                # returns list of dictionaries
                # pick the file you want to play with whatever logic
                labels = [file.get('name') for file in allfiles]
                num_items = len(allfiles)
                ret = select_dialog(f'{num_items} Items Found', labels, thumbnail)
                if ret == -1:
                    sys.exit()
                stream_url = allfiles[ret].get('link')
                hmf2 = resolveurl.HostedMediaFile(stream_url)
                if hmf2.valid_url():
                    link = resolveurl.resolve(stream_url)
       
        else:
            hmf = resolveurl.HostedMediaFile(link)
            if hmf.valid_url():
                link = hmf.resolve()
                
        liz.setPath(link)
        xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, liz)
        
        monitor_playback(item)
        return True
        