import json
import base64
from urllib.parse import quote_plus
from ..plugin import Plugin
from ..util.common import do_log

class DefaultProcessItem(Plugin):
    name = "default process item"
    priority = 0

    def process_item(self, item):
        do_log(f'{self.name} - Processing item:\n {json.dumps(item, indent=2)}')
        is_dir = False
        item_type = item.get("type")
        link = item.get("link", "")

        if link:
            if item_type == "dir":
                if link.endswith('.xml'):
                    link += 'l'
                elif link.endswith(".m3u") or link.endswith(".m3u8"):
                    link = f"m3u|{link}"
                link = f"/get_list/{link}"
                is_dir = True
            
            elif item_type == "plugin":
                if 'youtube' in link:
                    link = f"/get_list/{link}"
                    is_dir = True
                else:
                    link = f"/run_plug/{quote_plus(str(link))}"
            
            elif item_type == "script":
                link = f"/run_script/{quote_plus(str(link))}"
            
        if item_type == "item":
            link_item = base64.urlsafe_b64encode(json.dumps(item).encode('utf-8')).decode('utf-8')
            if str(link) in ("settings", "clear_cache", "remove_recents"):
                pass
            elif str(link).startswith("message/"):
                pass
            else:
                item['is_playable'] = True
                link = f"play_video/{link_item}"

        item["link"] = link
        item["is_dir"] = is_dir
        return item
        