import sys
from xbmcplugin import addDirectoryItems, endOfDirectory, setContent
from ..plugin import Plugin
from ..DI import DI

route_plugin = DI.plugin


class display(Plugin):
    name = "display"

    def display_list(self, jen_list):
        cache = True
        args = sys.argv[0]
        if 'get_list/searchdb' in args or 'get_list/tmdb/search/' in args:
            cache = False
        
        display_list = [(route_plugin.url_for_path(item["link"]), item["list_item"], item["is_dir"]) for item in jen_list]
        addDirectoryItems(route_plugin.handle, display_list, len(display_list))
        content = { item.get("content") for item in jen_list }
        category = "videos"
        if "movie" in content:
            category = "movies"
        elif "tvshow" in content or "season" in content:
            category = "tvshows"
        elif "episode" in content:
            category = "episodes"
        setContent(route_plugin.handle,  category)
        endOfDirectory(route_plugin.handle, cacheToDisc=cache)
        return True
