import datetime
import time
import xbmcgui
from ..util.common import default_icon, default_fanart
from resources.lib.plugin import Plugin


class guidedata(Plugin):
    name = "guidedata"
    priority = 100

    def get_metadata(self, item):
        if "guidedata" in item:
            ts = time.time()
            utc_offset = (datetime.datetime.fromtimestamp(ts) - datetime.datetime.utcfromtimestamp(ts)).total_seconds()
            current_time = ts
            label = "N/A"
            times = []
            for programme in item["guidedata"]:
                if programme["starttime"] >= (current_time - 9600):
                    start_time = datetime.datetime.utcfromtimestamp(programme["starttime"] + utc_offset)
                    end_time = datetime.datetime.utcfromtimestamp(programme["starttime"] + programme["duration"] + utc_offset)
                    label = f"{start_time.strftime('%I:%M %p')} - {end_time.strftime('%I:%M %p')}: [COLORred]{programme['label']}[/COLOR]"
                    times.append(label)
                if current_time >= programme["starttime"] and current_time <= programme["starttime"] + programme["duration"]:
                    start_time = datetime.datetime.utcfromtimestamp(programme["starttime"] + utc_offset)
                    end_time = datetime.datetime.utcfromtimestamp(programme["starttime"] + programme["duration"] + utc_offset)
                    label = f"{start_time.strftime('%I:%M %p')} - {end_time.strftime('%I:%M %p')}: {programme['label']}"
                    item["list_item"].setLabel(item["list_item"].getLabel() + f"\n{label}")
                    
            summary = "\n".join(times)
            content = item.get("content", "video")
            title = item.get("title", "")
            thumbnail = item.get("thumbnail", default_icon)
            fanart = item.get("fanart", default_fanart)
            infolabels = {
                "mediatype": content,
                "title": title,
                "plot": summary,
                "plotoutline": summary
            }
        
            liz = xbmcgui.ListItem(title, offscreen=True)
            liz.setArt(
                {
                    "thumb": thumbnail,
                    "icon": thumbnail,
                    "poster": thumbnail,
                    "fanart": fanart
                }
            )
            
            liz.setInfo("video", infolabels)
            item["list_item"] = liz
            return item
            