import json
import re
import sys
import requests
from bs4 import BeautifulSoup
import xbmc
from ..modules.dialogs import select_dialog
from ..plugin import Plugin
from ..util.common import default_icon


class pre_player(Plugin):
    name = "process lists of links"
    priority = 200
      
    def pre_play(self, video):
        item = json.loads(video)
        links = item.get('link', [])
        links = [links] if isinstance(links, str) else links
        thumbnail = item.get("thumbnail", default_icon)
        imdb = item.get('imdb')
        labels = []
        urls = []
        counter = 1
        for _link in links:
            label_extract = self.extract_label(_link)
            if label_extract is not None:
                labels.append(label_extract[0])
                urls.append(label_extract[1])
            else:
                labels.append(f'Link {counter}')
                urls.append(_link)
            counter += 1
        if len(urls) == 1:
            link = urls[0]
        else:
            ret = select_dialog('Choose a Link', labels, icon=thumbnail)
            if ret == -1:
                sys.exit()
            if labels[ret].lower() == 'trailer' and imdb:
                xbmc.sleep(500)
                labels2 = ['YouTube', 'IMDB']
                ret2 = select_dialog('Choose a Link', labels2, icon=thumbnail)
                if ret2 == -1:
                    sys.exit()
                if ret2 == 0:
                    link = urls[ret]
                else:
                    link = self.get_imdb_trailer(imdb)
                    if link is None:
                        sys.exit()
            else:
                link = urls[ret]
        item['link'] = link
        return json.dumps(item)
    
    def get_imdb_trailer(self, imdb_id):
        base_url = 'https://www.imdb.com/'
        user_agent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36'
        headers = {
            'User-Agent': user_agent,
            'Referer': f'{base_url}'
        }
        url = f'{base_url}title/{imdb_id}'
        response = requests.get(url, headers=headers, timeout=10).text
        soup = BeautifulSoup(response, 'html.parser')
        for script in soup.find_all('script'):
            try:
                text = script.text
                if 'embedUrl' in text:
                    trailer = json.loads(text)['trailer']['embedUrl'].rstrip('/')
                    video_id = trailer.split('/')[-1]
                    return f'plugin://plugin.video.imdb.trailers/?action=play&videoid={video_id}'
            except:
                continue
                
        
    def extract_label(self, link):
        pattern = '\(([^\)]+)\)$'
        if link.endswith(')'):
            match = re.search(pattern, link)
            if match:
                return [match.group(1), re.sub(pattern, '', link).strip()]
                