import sys
import re
import json
import time
import operator
from typing import List
from threading import Thread
import xbmc
import xbmcgui
import xbmcaddon
import xbmcplugin
import resolveurl
if xbmcaddon.Addon().getSetting('scraper.package') == 'Magneto':
    import magneto as cocoscrapers
else:
    import cocoscrapers
from ..modules.utils import ok_dialog, log, set_info

from ..modules.cache_check import RD, AD, PM
from ..modules.models import Item
from ..modules.dialogs import select_dialog
from ..modules.recently_played import monitor_playback
from ..plugin import Plugin


ADDON = xbmcaddon.Addon()
ADDON_ID = ADDON.getAddonInfo('id')
SETTING = ADDON.getSetting
SETTING_BOOL = ADDON.getSettingBool
MAX_SIZE = int(SETTING('max.size'))
MIN_SIZE = int(SETTING('min.size'))
Q4K = SETTING_BOOL('quality.4k')
Q1080P = SETTING_BOOL('quality.1080p')
Q720 = SETTING_BOOL('quality.720p')
QSD = SETTING_BOOL('quality.sd')
QCAM = SETTING_BOOL('quality.cam')
INCLUDE_UNCACHED = SETTING_BOOL('include.uncached')
SIZE_SORTING = int(SETTING('size.sorting'))
TIMEOUT = 30
NON_WORKING = []
PROGRESS = xbmcgui.DialogProgress()


class Cocoscrapers(Plugin):
    name = "cocscrapers"
    description = "Scrape with Cocoscrapers"
    priority = 102
    
    
    def play_video(self, video):
        if SETTING_BOOL('use.cocoscrapers') is False:
            return
        item = json.loads(video)

        link = item.get("link")
        title = re.sub("(\[.+?\])", "", item.get("title"))
        if link and link.startswith("search"):
            return self.get_sources(
                title,
                item.get('thumbnail', ''),
                str(item.get('year', '')),
                item.get('imdb_id', item.get('imdb')),
                item.get('summary', title),
                item.get('content', ''),
                item.get('season', ''),
                item.get('episode', ''),
                item.get('tv_show_title', title),
                item.get('total_seasons')
            )
            #return True
    
    
    def get_sources(self, name: str, icon: str, year: str, imdb: str, description: str, media_type: str, season_number=None, episode_number=None, tv_show_title=None, total_seasons: str=None):
        window = xbmcgui.Window(xbmcgui.getCurrentWindowId())
        items_cached = window.getProperty(f'{ADDON_ID}.container.item_list')
        if items_cached:
            items_cached = json.loads(items_cached)
            if name in items_cached and imdb in str(items_cached):
                item_list = items_cached[name]
                item_list = [Item(**item) for item in item_list]
                return self.resolve(item_list, name, icon, description, media_type)
        
        sources = []
        if media_type == 'movie':
            sources = self.scrape_movie(name, year, imdb, max_size=MAX_SIZE, min_size=MIN_SIZE)
        
        else:
            sources = self.scrape_episode(name, tv_show_title, year, imdb, season_number, episode_number, media_type=media_type, total_seasons=total_seasons, max_size=MAX_SIZE, min_size=MIN_SIZE)
        sources_sorted = []
        quality_sorted = []
        if Q4K is True:
            for source in sources:
                if source.get('quality').lower() == '4k':
                    quality_sorted.append(source)
            quality_sorted = sorted(quality_sorted, key=operator.itemgetter("size"))
            quality_sorted.reverse()
            sources_sorted.extend(quality_sorted)
        
        if Q1080P is True:
            quality_sorted = []
            for source in sources:
                if source.get('quality').lower() == '1080p':
                    quality_sorted.append(source)
            quality_sorted = sorted(quality_sorted, key=operator.itemgetter("size"))
            quality_sorted.reverse()
            sources_sorted.extend(quality_sorted)
        
        if Q720 is True:
            quality_sorted = []
            for source in sources:
                if source.get('quality').lower() == '720p':
                    quality_sorted.append(source)
            quality_sorted = sorted(quality_sorted, key=operator.itemgetter("size"))
            quality_sorted.reverse()
            sources_sorted.extend(quality_sorted)
        
        if QSD is True:
            quality_sorted = []
            for source in sources:
                if source.get('quality').lower() == 'sd':
                    quality_sorted.append(source)
            quality_sorted = sorted(quality_sorted, key=operator.itemgetter("size"))
            quality_sorted.reverse()
            sources_sorted.extend(quality_sorted)
        
        if QCAM is True:
            quality_sorted = []
            for source in sources:
                if source.get('quality').lower() == 'cam':
                    quality_sorted.append(source)
            quality_sorted = sorted(quality_sorted, key=operator.itemgetter("size"))
            quality_sorted.reverse()
            sources_sorted.extend(quality_sorted)
        hashes = []
        for source in sources_sorted:
            _hash = source.get('hash', '').lower()
            if _hash and _hash not in hashes:
                hashes.append(_hash)
                
            
        #hashes = [source['hash'] for source in sources_sorted]
        rd_cached_sources = []
        ad_cached_sources = []
        pm_cached_sources = []
        #cached_sources = []
        uncached_sources = []
        item_list = []
        rd_cached_hashes = []
        rd_cached_hashes = RD().check_cache(hashes, imdb, season_number, episode_number)
        if rd_cached_hashes:
            rd_cached_sources = [source for source in sources_sorted if source.get('hash', '').lower() in rd_cached_hashes]
            
            for source in rd_cached_sources:
                type_ = 'item'
                mode = 'tmdb_play_video'
                title = source.get('name')
                link = source.get('url')
                quality = source.get('quality')
                size = source.get('size')
                if size:
                    size = f'{size} GB'
                provider = source.get('provider')
                title = f'[B][COLOR red]{quality} | {size} | {provider.upper()} | Cached Torrent | REAL DEBRID[/COLOR][/B]\n[I][COLOR yellow]{title}[/I][/COLOR]'
                
                item_list.append(
                    Item(
                        title=title,
                        type=type_,
                        mode=mode,
                        title2=name,
                        thumbnail=icon,
                        link=link,
                        imdb_id=imdb,
                        summary=description
                    )
                )
                
        ad_cached_hashes = []
        ad_cached_hashes = AD().check_cache(hashes, imdb, season_number, episode_number)
        if ad_cached_hashes:
            ad_cached_sources = [source for source in sources_sorted if source.get('hash', '').lower() in ad_cached_hashes]
            
            for source in ad_cached_sources:
                type_ = 'item'
                mode = 'tmdb_play_video'
                title = source.get('name')
                link = source.get('url')
                quality = source.get('quality')
                size = source.get('size')
                if size:
                    size = f'{size} GB'
                provider = source.get('provider')
                title = f'[B][COLOR red]{quality} | {size} | {provider.upper()} | Cached Torrent | ALL DEBRID[/COLOR][/B]\n[I][COLOR yellow]{title}[/I][/COLOR]'
                
                item_list.append(
                    Item(
                        title=title,
                        type=type_,
                        mode=mode,
                        title2=name,
                        thumbnail=icon,
                        link=link,
                        imdb_id=imdb,
                        summary=description
                    )
                )
        
        pm_cached_hashes = PM().check_cache(hashes)
        if pm_cached_hashes:
            pm_cached_sources = [source for source in sources_sorted if source.get('hash', '').lower() in pm_cached_hashes]
            
            for source in pm_cached_sources:
                type_ = 'item'
                mode = 'tmdb_play_video'
                title = source.get('name')
                link = source.get('url')
                quality = source.get('quality')
                size = source.get('size')
                if size:
                    size = f'{size} GB'
                provider = source.get('provider')
                title = f'[B][COLOR red]{quality} | {size} | {provider.upper()} | Cached Torrent | PREMIUMIZE[/COLOR][/B]\n[I][COLOR yellow]{title}[/I][/COLOR]'
                
                item_list.append(
                    Item(
                        title=title,
                        type=type_,
                        mode=mode,
                        title2=name,
                        thumbnail=icon,
                        link=link,
                        imdb_id=imdb,
                        summary=description
                    )
                )
               
        if rd_cached_sources or ad_cached_sources or pm_cached_sources:
            for source in sources_sorted:
                _hash = source.get('hash', '').lower()
                if _hash not in rd_cached_hashes and _hash not in ad_cached_hashes and _hash not in pm_cached_hashes:
                    if source not in uncached_sources:
                        uncached_sources.append(source)
            if INCLUDE_UNCACHED is True:
                for source in uncached_sources:
                    type_ = 'item'
                    mode = 'tmdb_play_video'
                    title = source.get('name')
                    link = source.get('url')
                    quality = source.get('quality')
                    size = source.get('size')
                    if size:
                        size = f'{size} GB'
                    provider = source.get('provider')
                    if pm_cached_hashes:
                        title = f'[B][COLOR pink]{quality} | {size} | {provider.upper()} | Uncached Torrent[/COLOR][/B]\n[I][COLOR yellow]{title}[/I][/COLOR]'
                    else:
                        title = f'[B][COLOR pink]{quality} | {size} | {provider.upper()} | Unchecked Torrent[/COLOR][/B]\n[I][COLOR yellow]{title}[/I][/COLOR]'
                    item_list.append(
                       Item(
                            title=title,
                            type=type_,
                            mode=mode,
                            title2=name,
                            thumbnail=icon,
                            link=link,
                            imdb_id=imdb,
                            summary=description
                        )
                    )
        
        
        if not rd_cached_sources and not ad_cached_sources and not pm_cached_sources:
            for source in sources_sorted:
                type_ = 'item'
                mode = 'tmdb_play_video'
                title = source.get('name')
                link = source.get('url')
                quality = source.get('quality')
                size = source.get('size')
                if size:
                    size = f'{size} GB'
                provider = source.get('provider')
                title = f'[B][COLOR red]{quality} | {size} | {provider.upper()}\n[I][COLOR yellow]{title}[/I][/COLOR][/B]'
                
                item_list.append(
                    Item(
                        title=title,
                        type=type_,
                        mode=mode,
                        title2=name,
                        thumbnail=icon,
                        link=link,
                        imdb_id=imdb,
                        summary=description
                    )
                )
        
        if not item_list:
            ok_dialog('No links found.')
            sys.exit()
         
        if SIZE_SORTING == 1:
            item_list.reverse()
        window.clearProperty(f'{ADDON_ID}.container.item_list')
        window.setProperty(f'{ADDON_ID}.container.item_list', json.dumps({name: [item.to_dict() for item in item_list]}))
        
        return self.resolve(item_list, name, icon, description, media_type)
    

    def resolve(self, item_list: List[Item], name:str, icon: str, description: str, media_type: str):
        xbmc.executebuiltin('Dialog.Close(busydialog)')
        labels = [item.title for item in item_list]
        num_items = len(labels)
        icon = ADDON.getAddonInfo('icon') if not icon else icon
        
        ret = select_dialog(f'{num_items} Items Found', labels, icon)
        if ret == -1:
            return
        item_list = item_list[ret:]
        item = None
        progress = xbmcgui.DialogProgress()
        progress.create('Resolving Link...', f'[B][COLOR snow]Resolving:[/COLOR][/B]\n{item_list[0].title}')
        progress.update(0)
        index = 0
        for item_ in item_list:
            link = ''
            if progress.iscanceled():
                break
            percentage = int(100/(len(item_list) - index))
            progress.update(percentage, f'[B][COLOR snow]Resolving:[/COLOR][/B]\n{item_.title}')
            link = item_.link
            try:
                if media_type == 'season':
                    hmf = resolveurl.HostedMediaFile(link, return_all=True)
                    if hmf:
                        allfiles = hmf.resolve()
                        # returns list of dictionaries
                        # pick the file you want to play with whatever logic
                        labels = [file.get('name') for file in allfiles]
                        num_items = len(allfiles)
                        ret = select_dialog(f'{num_items} Items Found', labels, icon)
                        if ret == -1:
                            sys.exit()
                        stream_url = allfiles[ret].get('link')
                        hmf2 = resolveurl.HostedMediaFile(stream_url)
                        if hmf2.valid_url():
                            link = resolveurl.resolve(stream_url)
                        elif stream_url.startswith('https://alldebrid.com'):
                            link = AD().resolve(stream_url)
                        else:
                            link = stream_url
                else:
                    hmf = resolveurl.HostedMediaFile(link)
                    if hmf.valid_url():
                        link = hmf.resolve()
                    else:
                        link = ''
            except Exception as e:
                log(f'Error Resolving Url: {e}')
                link = ''
            if link:
                item = item_
                progress.update(100, f'[B][COLOR snow]Resolving:[/COLOR][/B]\n{item_.title}')
                xbmc.sleep(200)
                break
            index += 1
        if progress.iscanceled():
            progress.close()
            return
        progress.close()
        xbmc.executebuiltin('Dialog.Close(busydialog)')
        xbmc.sleep(500)
        if not link:
            return
        tmdb_id = item.tmdb_id
        imdb_id = item.imdb_id
        liz = xbmcgui.ListItem(item.title, path=link, offscreen=True)
        liz.setPath(link)
        set_info(liz, {'title': name, 'plot': description})
        from ..modules.tmdb_api import get_clearlogo
        clearlogo = get_clearlogo(tmdb_id, imdb_id)
        liz.setArt({'thumb': icon, 'icon': icon, 'poster': icon, 'clearlogo': clearlogo})
        #xbmc.Player().play(link, listitem=liz)
        xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, liz)
        monitor_playback(item.to_dict())
        return True
    
    
    ######
    
    def get_movie(self, title, year, imdb, source_obj, result):
        data = {'title': title, 'aliases': title, 'year': year, 'imdb': imdb}
        hostDict = []
        movie = source_obj().sources(data, hostDict)
        result.extend(movie)
        if not result:
            return []
        return result
        
        
    def movie_threads(self, title, year, imdb, sources: list):
        threads = []
        for n, s in sources:
            result = []
            if n in NON_WORKING:
                continue
        
            thread = Thread(
                target=self.get_movie,
                args=(
                    title,
                    year,
                    imdb,
                    s,
                    result,
                ),
            )
            threads.append([thread, result])
        return threads
    
    def scrape_movie(self, title, year, imdb, quality: list=None, max_size: int=None, min_size=None):
        if xbmcaddon.Addon().getSetting('scraper.package') == 'Magneto':
            package = 'Magneto'
        else:
            package = 'Cocoscrapers'
        PROGRESS.create(f'{package}: Scraping Movie Sources...')
        all_sources = []
        sources = cocoscrapers.sources(ret_all=False)
        threads = self.movie_threads(title, year, imdb, sources)
        for t in threads:
            t[0].start()
        start_time = time.monotonic()
        end_time = TIMEOUT + start_time
        while True:
            if not threads or PROGRESS.iscanceled():
                PROGRESS.close()
                break
            for t in threads:
                percentage = int(100 / len(threads))
                if percentage < 0:
                    percentage = 0
                PROGRESS.update(percentage, message='Finding movie links.\nThis may take several seconds...')
                wait_timeout = end_time - time.monotonic()
                if t[0].is_alive() and wait_timeout > 0:
                    continue
                else:
                    result = t[1]
                    threads.remove(t)
                    if result:
                        all_sources.extend(result)
        
        return self.sort_sources(all_sources, max_size, min_size, quality)
        
    
    def get_episode(self, title, tvshowtitle, year, imdb, season, episode, source_obj, result, media_type: str='episode', total_seasons: str=None):
        data = {
            'title': title,
            'aliases': title,
            'tvshowtitle': tvshowtitle,
            'year': year,
            'imdb': imdb,
            'season': season,
            'episode': episode,
            'total_seasons': total_seasons
        }
        hostDict = []
        if media_type == 'episode':
            item = source_obj().sources(data, hostDict)
        elif media_type == 'season':
            item = source_obj().sources_packs(data, hostDict)
        result.extend(item)
        if not result:
            return []
        return result
        
    
    def episode_threads(self, title, tvshowtitle, year, imdb, season, episode, sources: list, media_type: str='episode', total_seasons: str=None):
        threads = []
        for n, s in sources:
            result = []
            if n in NON_WORKING:
                continue
            
            thread = Thread(
                target=self.get_episode,
                args=(
                    title,
                    tvshowtitle,
                    year,
                    imdb,
                    season,
                    episode,
                    s,
                    result,
                    media_type,
                    total_seasons,
                ),
            )
            threads.append([thread, result])
        return threads
    
    def scrape_episode(self, title, tvshowtitle, year, imdb, season, episode, media_type: str='episode', total_seasons: str=None, quality: list=None, max_size: str=None, min_size=None):
        all_sources = []
        if media_type == 'tvshow':
            pass
        elif media_type == 'season':
            pass
        sources = cocoscrapers.sources(ret_all=False)
        threads = self.episode_threads(title, tvshowtitle, year, imdb, season, episode, sources, media_type=media_type, total_seasons=total_seasons)
        if xbmcaddon.Addon().getSetting('scraper.package') == 'Magneto':
            package = 'Magneto'
        else:
            package = 'Cocoscrapers'
        PROGRESS.create(f'{package}: Scraping Episode Sources...')
        for t in threads:
            t[0].start()
        start_time = time.monotonic()
        end_time = TIMEOUT + start_time
        while True:
            if not threads or PROGRESS.iscanceled():
                PROGRESS.close()
                break
            for t in threads:
                percentage = int(100 / len(threads))
                if percentage < 0:
                    percentage = 0
                PROGRESS.update(percentage, message='Finding episode links.\nThis may take several seconds...')
                wait_timeout = end_time - time.monotonic()
                if t[0].is_alive() and wait_timeout > 0:
                    continue
                result = t[1]
                threads.remove(t)
                if result:
                    all_sources.extend(result)
        return self.sort_sources(all_sources, max_size, min_size, quality)
        
    def sort_sources(self, all_sources: list, max_size: int=0, min_size: int=0, quality: list=None) -> list:
        all_sources = sorted(all_sources, key=operator.itemgetter("quality"))
        if max_size > 0:
            all_sources = [source for source in all_sources if source.get('size', 0) <= max_size]
        if min_size:
            all_sources = [source for source in all_sources if source.get('size', 0) >= min_size]
            
        if quality:
            all_sources_filtered = []
            if '4k' in quality or '4K' in quality:
                for source in all_sources:
                    if source.get('quality') == '.4K':
                        all_sources_filtered.append(source)
            if '1080p' in quality:
                for source in all_sources:
                    if source.get('quality') == '1080p':
                        all_sources_filtered.append(source)
            if '720p' in quality:
                for source in all_sources:
                    if source.get('quality') == '720p':
                        all_sources_filtered.append(source)
            if 'SD' in quality or 'sd' in quality:
                for source in all_sources:
                    if source.get('quality') == 'SD':
                        all_sources_filtered.append(source)
            if 'CAM' in quality or 'cam' in quality:
                for source in all_sources:
                    if source.get('quality') == 'CAM':
                        all_sources_filtered.append(source)
            if all_sources_filtered:
                all_sources = all_sources_filtered
        return all_sources
        