# Used across all addon
import os
import xbmc
import xbmcgui
import xbmcaddon
import xbmcvfs
from ..plugin import Plugin
from ..DI import DI

ownAddon = xbmcaddon.Addon()
addon_id = ownAddon.getAddonInfo('id')
debugMode = ownAddon.getSettingBool('debug')
addon_path = ownAddon.getAddonInfo("path")
default_icon = ownAddon.getAddonInfo('icon')
default_fanart = ownAddon.getAddonInfo('fanart')
kodi_ver = float(xbmc.getInfoLabel("System.BuildVersion")[:4])
short_checker = (
    'Adf.ly', 
    'Bit.ly', 
    'Chilp.it', 
    'Clck.ru', 
    'Cutt.ly', 
    'Da.gd', 
    'Git.io', 
    'goo.gl', 
    'Is.gd', 
    'NullPointer', 
    'Os.db', 
    'Ow.ly', 
    'Po.st', 
    'Qps.ru', 
    'Short.cm', 
    'Tiny.cc', 
    'TinyURL.com', 
    'Git.io', 
    'Tiny.cc'
)
     

def do_log(info):
    if debugMode is True:
        xbmc.log(f' > MicroJen Log > \n {info}', xbmc.LOGINFO)

def set_info(liz: xbmcgui.ListItem, infolabels: dict, cast: list=None):
    cast = cast or []
    if kodi_ver < 20:
        liz.setInfo("video", infolabels)
        liz.setCast(cast)
    else:
        i = liz.getVideoInfoTag()
        i.setMediaType(infolabels.get("mediatype", "video"))
        i.setTitle(infolabels.get("title", "Unknown"))
        i.setPlot(infolabels.get("plot", infolabels.get("title", "")))
        i.setTagLine(infolabels.get("tagline", ""))
        i.setPremiered(infolabels.get("premiered", ""))
        i.setGenres(infolabels.get("genre", []))
        i.setMpaa(infolabels.get("mpaa", ""))
        i.setDirectors(infolabels.get("director", []))
        i.setWriters(infolabels.get("writer", []))
        i.setRating(infolabels.get("rating", 0))
        i.setVotes(infolabels.get("votes", 0))
        i.setStudios(infolabels.get("studio", []))
        i.setCountries(infolabels.get("country", []))
        i.setSet(infolabels.get("set", ""))
        i.setTvShowStatus(infolabels.get("status", ""))
        i.setDuration(infolabels.get("duration", 0))
        i.setTrailer(infolabels.get("trailer", ""))

        cast_list = []
        for actor in cast:
            cast_list.append(xbmc.Actor(
                name=actor.get("name", ""),
                role=actor.get("role", ""),
                thumbnail=actor.get("thumbnail", "")
            ))
        i.setCast(cast_list)

def from_keyboard(default_text='', header=''):
    kb = xbmc.Keyboard(default_text, header, False)
    kb.doModal()
    if (kb.isConfirmed()):
        if kb.getText() == '':
            return None
        return kb.getText()
    else:
        return None

class Message(Plugin):
    name = "pop up message box"
    priority = 0
    
    def routes(self, plugin):
        @plugin.route("/message/<path:url>")
        def show_message(url, header = 'Information'):
            if url.lower().startswith("http"):
                message = DI.session.get(url).text
            elif url.lower().startswith("file://"):
                url = url.replace("file://", "")
                input_file = xbmcvfs.File(os.path.join(addon_path, "xml", url))
                message = input_file.read()
            else:
                message = url
            
            xbmc.executebuiltin("ActivateWindow(10147)")
            controller = xbmcgui.Window(10147)
            xbmc.sleep(500)
            controller.getControl(1).setLabel(header)
            controller.getControl(5).setText(f"{message}")
            