from slyguy import plugin


class TrailerItem(plugin.Item):
    def __init__(self, *args, **kwargs):
        kwargs['properties'] = kwargs.get('properties') or {}
        # support added to trakt in https://github.com/trakt/script.trakt/pull/670 (not released yet)
        kwargs['properties']['script.trakt.exclude'] = '1'
        kwargs['no_resume'] = True
        super(TrailerItem, self).__init__(*args, **kwargs)


YOTUBE_PLUGIN_ID = 'plugin.video.youtube'
TUBED_PLUGIN_ID = 'plugin.video.tubed'

MDBLIST_API_KEY = 'tliqxfv0tg537ff7xyqkv7tug'
MDBLIST_API_URL = 'https://api.mdblist.com{}'
SEARCH_MATCH_RATIO = 0.75

IMDB_API_URL = 'https://graphql.prod.api.imdb.a2z.com/'
IMDB_VIDEO_URL = 'https://www.imdb.com/video/{}/'
IMDB_API_HEADERS = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36',
    'Accept-Language': 'en-US,en',
    'Accept-Encoding': 'gzip',
    'Referer': 'https://www.imdb.com/',
    'Origin': 'https://www.imdb.com',
}
IMDB_QUALITY_MAP = {
    'DEF_1080p': '1920x1080',
    'DEF_720p': '1280x720',
    'DEF_480p': '864x480',
    'DEF_SD': '480x272',
}
