from slyguy.session import Session
from slyguy.exceptions import Error

from .language import _
from .constants import MDBLIST_API_KEY, MDBLIST_API_URL


class APIError(Error):
    pass


class API(object):
    def __init__(self):
        self._session = Session(base_url=MDBLIST_API_URL)

    def _get_media_type(self, mediatype):
        mediatype = mediatype.lower()
        if mediatype in ('tvshow', 'show'):
            return 'show'
        elif mediatype in ('movie',):
            return 'movie'
        return None

    def _get_id_type(self, id_type):
        id_type = id_type.lower()
        if id_type.endswith('id'):
            return id_type[:-2]
        else:
            return id_type

    def search_media(self, mediatype, title, year, limit=10):
        mediatype = self._get_media_type(mediatype)

        params = {
            'query': title,
            'year': year,
            'limit': limit,
            'limit_by_score': 30,
            'sort_by_score': True,
            'apikey': MDBLIST_API_KEY,
        }
        data = self._session.get('/search/{}'.format(mediatype), params=params).json()
        if 'search' not in data:
            raise APIError(_(_.FAILED_SEARCH, error=data.get('message'), mediatype=mediatype, title=title, year=year))
        return data['search']

    def get_media(self, mediatype, id, id_type=None):
        mediatype = self._get_media_type(mediatype)

        id_types = []
        if not id_type:
            if 'tt' in id.lower():
                id_types = ['imdb']
            elif mediatype == 'movie':
                id_types = ['tmdb']
            else:
                # can be tvdb or tmdb for shows
                id_types = ['tvdb', 'tmdb']
        else:
            id_types = [self._get_id_type(id_type)]

        params = {
            'apikey': MDBLIST_API_KEY,
        }
        for id_type in id_types:
            data = self._session.get('/{}/{}/{}'.format(id_type, mediatype, id), params=params).json()
            if data.get('title'):
                return data

        return {}
