import importlib.resources

from yt_dlp.extractor.youtube.jsc._builtin.vendor._info import HASHES, VERSION

__all__ = ['HASHES', 'VERSION', 'load_script']


def load_script(filename, error_hook=None):
    try:
        return importlib.resources.read_text(__package__, filename, encoding='utf-8')
    except (FileNotFoundError, OSError, ModuleNotFoundError) as e:
        if error_hook:
            error_hook(e)
        return None
